/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;

@Singleton
public class EntitySelectedGuiView
implements GuiView,
GameContextAware {
    private final Skin uiSkin;
    private final MessageDispatcher messageDispatcher;
    private final I18nTranslator i18nTranslator;
    private final GameInteractionStateContainer gameInteractionStateContainer;
    private Table entityDescriptionTable;
    private GameContext gameContext;

    @Inject
    public EntitySelectedGuiView(GuiSkinRepository guiSkinRepository, MessageDispatcher messageDispatcher, I18nTranslator i18nTranslator, GameInteractionStateContainer gameInteractionStateContainer) {
        this.uiSkin = guiSkinRepository.getDefault();
        this.messageDispatcher = messageDispatcher;
        this.i18nTranslator = i18nTranslator;
        this.gameInteractionStateContainer = gameInteractionStateContainer;
        this.entityDescriptionTable = new Table(this.uiSkin);
        this.entityDescriptionTable.background("default-rect");
        this.entityDescriptionTable.pad(10.0f);
    }

    @Override
    public void populate(Table containerTable) {
        this.update();
        containerTable.clear();
        containerTable.add(this.entityDescriptionTable);
    }

    @Override
    public void update() {
        this.entityDescriptionTable.clear();
        Entity entity = this.gameInteractionStateContainer.getSelectedEntity();
        if (entity != null) {
            this.entityDescriptionTable.add(new Label((CharSequence)this.i18nTranslator.getDescription(entity), this.uiSkin)).left();
            this.entityDescriptionTable.row();
            this.entityDescriptionTable.add(new Label((CharSequence)this.i18nTranslator.getCurrentGoalDescription(entity, this.gameContext), this.uiSkin)).left();
            this.entityDescriptionTable.row();
            this.entityDescriptionTable.row();
        }
    }

    @Override
    public GuiViewName getName() {
        return GuiViewName.ENTITY_SELECTED;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }

    @Override
    public void onLanguageUpdated() {
    }
}

